---------------------------------------------------------------------------------------------------------
-- BEGIN HEADER
---------------------------------------------------------------------------------------------------------
-- DDL for Alkindi Schema Model Version 0.5
-- DDL creates tables
-- Myles Weber, Appian Corporation
-- Weber@AppianCorp.com
-- September 27, 2000
-- Date Created: 
-- Date Updated: October 5, 2000 MSW
---------------------------------------------------------------------------------------------------------
-- END HEADER
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CHANGE LOG SINCE VERSION 0.4
---------------------------------------------------------------------------------------------------------
-- WHO WHEN   WHAT
-- MSW 092800 Added columns TITLE, ACTOR, DIRECTOR to MOVIE_DETAIL table
-- MSW 100200 Added column CALC_M11 per BWL request
-- MSW 100200 Added UNIQUE CONSTRAINT(UN_EVALUATION_USER_ID_PROD_ID) to EVALUATION table on columns USER_ID and PRODUCT_ID
-- MSW 100300 Added ERRORS Table to store exceptions
-- MSW 100300 Deleted USER_CLUSTER_DESC column from USER_CLUSTER table
-- MSW 100300 Deleted table REL_PRODUCT_CLUSTER_USER because USER_CLUSTER_PRODUCT_STAT caused it to be redundant 
-- MSW 100300 Added PRODUCT_CLUSTER_STAT Table
-- MSW 100300 Added USER_CLUSTER_STAT Table
-- MSW 100300 Added PRODUCT_STAT Table
-- MSW 100300 Added USER_STAT Table
-- MSW 100300 Added PRODUCT_CLUSTER_USER_STAT Table
-- MSW 100300 Renamed USER_CLUSTER_PRODUCT_STAT.TOTAL_OF_USER_SEEN_PROD  -> TOTAL_USER_SEEN
-- MSW 100300 Renamed USER_CLUSTER_PRODUCT_STAT.TOTAL_OF_USER_ASK_PROD   -> TOTAL_USER_EVAL
-- MSW 100300 Renamed USER_CLUSTER_PRODUCT_STAT.FRACTION_OF_UC_SEEN_PROD -> FRACTION_OF_UC_SEEN
-- MSW 100300 Renamed USER_CLUSTER_PRODUCT_STAT.FRACTION_OF_UC_ASK_PROD  -> FRACTION_OF_UC_EVAL
-- MSW 100300 Renamed PRODUCT_CLUSTER.PRODUCT_CLUSTER_ACTIVE to PRODUCT_CLUSTER.PRODUCT_CLUSTER_ACTIVE_IND
-- MSW 100300 Changed datatype of PRODUCT_CLUSTER.PRODUCT_CLUSTER_ACTIVE_IND from CHAR(1) to NUMBER(1)
-- MSW 100300 Added all_user_prod_comb view
-- MSW 100400 Renamed USER_CLUSTER_PRODUCT_STAT to PRODUCT_USER_CLUSTER_STAT
-- MSW 100400 Added Column NEW_ADDITION_IND to PRODUCT_STAT
-- MSW 100500 Added Column PRODUCT_WEIGHT to TABLE PRODUCT_STAT, 1/# of Product Clusters this product belongs to
-- MSW 100500 Added Column W_TOTAL_PROD_IN_PC to TABLE PRODUCT_CLUSTER_STAT, Weight sum of products in PC
-- MSW 100500 Added Column W_TOTAL_NEW_PROD_IN_PC to TABLE PRODUCT_CLUSTER_STAT, Weight sum of NEW products in PC
-- MSW 100500 Added Column W_TOTAL_OLD_PROD_IN_PC to TABLE PRODUCT_CLUSTER_STAT, Weight sum of OLD products in PC
-- MSW 100500 Added Column TOTAL_NEW_PROD_EVAL to USER_PRODUCT_CLUSTER_STAT
-- MSW 100500 Added Column AVG_NEW_PROD_EVAL to USER_PRODUCT_CLUSTER_STAT
-- MSW 100500 Added Column TOTAL_NEW_PROD_SEEN to USER_PRODUCT_CLUSTER_STAT
-- MSW 100500 Added Column FRACTION_OF_NEW_EVAL_SEEN to USER_PRODUCT_CLUSTER_STAT
-- MSW 100500 Added Column FRACTION_OF_PC_EVAL to USER_PRODUCT_CLUSTER_STAT
-- MSW 100500 Added Column TOTAL_NEW_PROD_IN_PC to TABLE PRODUCT_CLUSTER_STAT
-- MSW 100500 Added Column TOTAL_OLD_PROD_IN_PC to TABLE PRODUCT_CLUSTER_STAT

---------------------------------------------------------------------------------------------------------
-- END CHANGE LOG SINCE VERSION 0.4
---------------------------------------------------------------------------------------------------------



--------------------------------------------------------------------------------------------------------
-- BEGIN SCHEMA CREATION
---------------------------------------------------------------------------------------------------------

CREATE TABLE ERRORS (									-- MSW 100300 Stores Exceptions
ERROR_ID			NUMBER(3),
ERROR_MESSAGE		VARCHAR2(512)
);

CREATE TABLE PRODUCT_TYPE (
PRODUCT_TYPE_ID			NUMBER(2) 	 	PRIMARY KEY,		-- movie, music or book
PRODUCT_TYPE_DESC			VARCHAR2(2000)
);

CREATE TABLE PRODUCT_CATEGORY (							-- Genres
PRODUCT_CATEGORY_ID	 	NUMBER(3) 		PRIMARY KEY,
PRODUCT_TYPE_ID			NUMBER(2),
PRODUCT_CATEGORY_DESC		VARCHAR2(2000)
);

CREATE TABLE MOVIE (
PRODUCT_ID		 		NUMBER(10) 	 	PRIMARY KEY,
PRODUCT_TYPE_ID			NUMBER(2),
TITLE					VARCHAR2(2000),
MOVIE_DESC				VARCHAR2(2000),
ACTOR					VARCHAR2(2000),
DIRECTOR				VARCHAR2(2000)
);

CREATE TABLE BOOK (
PRODUCT_ID		 		NUMBER(10) 	 	PRIMARY KEY,		
PRODUCT_TYPE_ID			NUMBER(2),
BOOK_DESC				VARCHAR2(2000)
);

CREATE TABLE MUSIC (
PRODUCT_ID				NUMBER(10) 	 	PRIMARY KEY,
PRODUCT_TYPE_ID			NUMBER(2),
MUSIC_DESC				VARCHAR2(2000)
);

CREATE TABLE REL_PRODUCT_CATEGORY (
PRODUCT_ID	 			NUMBER(10),
PRODUCT_CATEGORY_ID 		NUMBER(3)
);

CREATE TABLE QUESTION (
QUESTION_ID				NUMBER(2)		PRIMARY KEY,
QUESTION_DESC			VARCHAR2(2000)
);

CREATE TABLE USER_STATUS (								-- PRD147
USER_STATUS_ID			NUMBER(2)		PRIMARY KEY,
USER_STATUS_DESC			VARCHAR2(2000)
);

CREATE TABLE USER_ID (
USER_ID 				NUMBER(10)		PRIMARY KEY,
DATE_CREATED			DATE
);

CREATE TABLE USER_DETAIL (								-- PRD210, PRD211, PRD212
USER_ID	 			NUMBER(10)		PRIMARY KEY,
EMAIL					VARCHAR2(40)			UNIQUE,	-- PRD113
SCREENNAME				VARCHAR2(15)	NOT NULL	UNIQUE,	-- PRD114, PRD120, PRD121, EMAIL from Sacha 9/18/00
PASSWORD				VARCHAR2(16), 					-- PRD115, PRD133
QUESTION1				NUMBER(2),						-- PRD117
ANSWER1				VARCHAR2(30),					-- PRD117, EMAIL from Sacha 9/18/00
QUESTION2				NUMBER(2),						-- PRD117
ANSWER2				VARCHAR2(30),					-- PRD117, EMAIL from Sacha 9/18/00
HOME_ZIP_CODE			VARCHAR2(10),					-- PRD142, EMAIL from Sacha 9/18/00
SEX_ID				NUMBER(1),						-- PRD143
BIRTHDATE				DATE,		 					-- PRD141
EDUCATION_ID			NUMBER(1),						-- PRD144, 5.29, Some High School, Graduated High School, Some College, Graduated College, Post-Graduate Degree
WEEKLY_ENT_EXP			NUMBER(5,0),					-- dollar weekly entertainment expense, EMAIL from Sacha 9/18/00
USER_STATUS_ID			NUMBER(2),						-- PRD146, PRD147, 1-6, user (default), member, dormant
ADVISOR_STATUS_ID			NUMBER(2)						-- PRD148, PRD149, 1-6, normal (default), suspended, dormant
);

CREATE TABLE USER_CATEGORY (								-- VERSION 0.2
USER_CATEGORY_ID 			NUMBER(10)		PRIMARY KEY,
USER_CATEGORY_DESC		VARCHAR2(2000)
);

CREATE TABLE REL_USER_CATEGORY (							-- VERSION 0.2
USER_ID		 		NUMBER(10),
USER_CATEGORY_ID			NUMBER(10)
);

CREATE TABLE PRODUCT_CLUSTER (
PRODUCT_CLUSTER_ID 		NUMBER(10)		PRIMARY KEY,
PRODUCT_CLUSTER_DESC 		VARCHAR2(2000),
PRODUCT_CLUSTER_ACTIVE_IND	NUMBER(1)         NOT NULL			-- BK092400 - Need to know which product clusters are active.
);

CREATE TABLE REL_PRODUCT_CLUSTER (
PRODUCT_CLUSTER_ID 		NUMBER(10),
PRODUCT_INDEX 			NUMBER(10),
PRODUCT_ID	 			NUMBER(10)
);

CREATE TABLE USER_CLUSTER (
USER_CLUSTER_ID		 	NUMBER(10)		PRIMARY KEY,
USER_CLUSTER_INDEX	 	NUMBER(10),
PRODUCT_CLUSTER_ID		NUMBER(10)
);

CREATE TABLE REL_USER_CLUSTER (
USER_CLUSTER_ID	 		NUMBER(10),
USER_ID	 			NUMBER(10)
);

CREATE TABLE EVALUATION (								-- PRD196
USER_ID 				NUMBER(10),
PRODUCT_ID	 			NUMBER(10),
EVALUATION_SCALE_ID		NUMBER(1),		 				-- PRD78, 9 options, Strongly Dislike, Dislike, Somewhat Dislike, Somewhat Like, Like, Strongly Like, INTERESTed, Not INTERESTed, Don't Know
EVALUATION_TIMESTAMP		DATE,							-- EMAIL from Roger 9/21/00
CONSTRAINT UN_EVALUATION_USER_ID_PROD_ID UNIQUE (USER_ID, PRODUCT_ID)
);

CREATE TABLE RECOMMENDATION (
USER_ID	 			NUMBER(10),
PRODUCT_ID	 			NUMBER(10),
RECOMMENDATION_DATE		DATE,
UNINTERESTED_IND			CHAR(1)
);

CREATE TABLE CATEGORY_RULE (								-- Version 2.0, EMAIL from Sacha 9/19/00
PRODUCT_CATEGORY_ID		NUMBER(10),
USER_CATEGORY_ID			NUMBER(10),
CATEGORY_RULE_DESC		VARCHAR2(2000)
);

CREATE TABLE USER_MY_LIST (								-- PRD412
USER_ID	 			NUMBER(10),
PRODUCT_ID	 			NUMBER(10),						-- PRD413, PRD414, PRD415, Retrieve additional data from product table
DATE_ADDED	 			DATE							-- PRD518
);

CREATE TABLE USER_FRIEND_EMAIL (							-- PRD170
USER_ID	 			NUMBER(10),
FRIEND_EMAIL			VARCHAR2(40),
DATE_ADDED	 			DATE
);

CREATE TABLE OTHER_TYPE (
OTHER_TYPE_ID			NUMBER(2)		PRIMARY KEY,
OTHER_TYPE_DESC			VARCHAR2(2000)
);

CREATE TABLE USER_OTHER_ENTRY (
USER_ID				NUMBER(10),
OTHER_TYPE_ID			NUMBER(2),
OTHER_VALUE				VARCHAR2(30),
OTHER_VALUE_INDEX			NUMBER(2)						-- Added by MSW 9/22/00
);

CREATE TABLE USER_PRODUCT_REVIEW (
USER_ID				NUMBER(10),
PRODUCT_ID				NUMBER(10),
PRODUCT_REVIEW			VARCHAR2(2000),
DATE_ADDED		 		DATE
);

CREATE TABLE SEX (									-- PRD143
SEX_ID				NUMBER(1)		PRIMARY KEY, 		
SEX_DESC				VARCHAR2(6)						-- AHW100200 changed datatype length
); 

CREATE TABLE EVALUATION_SCALE (							-- PRD78
EVALUATION_SCALE_ID		NUMBER(1)		PRIMARY KEY, 				
EVALUATION_SCALE_DESC		VARCHAR2(2000)
);

CREATE TABLE EDUCATION (								-- PRD144
EDUCATION_ID			NUMBER(2)		PRIMARY KEY, 
EDUCATION_DESC			VARCHAR2(2000)
);

CREATE TABLE ADVISOR_STATUS (
ADVISOR_STATUS_ID			NUMBER(2)		PRIMARY KEY, 		-- PRD148,PRD149
ADVISOR_STATUS_DESC		VARCHAR2(2000)
);

CREATE TABLE PROFESSION_TYPE (							
PROFESSION_TYPE_ID		NUMBER(2)		PRIMARY KEY, 
PROFESSION_TYPE_DESC		VARCHAR2(2000)
); 

CREATE TABLE PROFESSION (								-- PRD214, PRD215, PRD216
PROFESSION_ID 			NUMBER(3)		PRIMARY KEY, 
PROFESSION_TYPE_ID		NUMBER(2),
PROFESSION_DESC			VARCHAR2(2000)
); 

CREATE TABLE LANGUAGE (
LANGUAGE_ID				NUMBER(2)		PRIMARY KEY, 
LANGUAGE_DESC			VARCHAR2(2000) 
);

CREATE TABLE SPORTS (
SPORTS_ID				NUMBER(2) 		PRIMARY KEY,
SPORTS_DESC				VARCHAR2(2000)
);

CREATE TABLE ACTIVITY (
ACTIVITY_ID 			NUMBER(2) 		PRIMARY KEY, 
ACTIVITY_DESC			VARCHAR2(2000)
); 

CREATE TABLE INTEREST (									-- PRD280
INTEREST_ID				NUMBER(2) 		PRIMARY KEY, 
INTEREST_DESC 			VARCHAR2(2000)
); 

CREATE TABLE MOVIE_GENRE (								-- PRD314-PRD329
MOVIE_GENRE_ID			NUMBER(2) 		PRIMARY KEY, 
MOVIE_GENRE_DESC 			VARCHAR2(50) 	
); 

CREATE TABLE REL_USER_MOVIE_GENRE (
USER_ID 				NUMBER(10), 
MOVIE_GENRE_ID		 	NUMBER(10)
);

CREATE TABLE REL_USER_PROFESSION (							-- PRD214, PRD215, PRD216
USER_ID 				NUMBER(10), 
PROFESSION_ID		 	NUMBER(10)
);

CREATE TABLE REL_USER_LANGUAGE (
USER_ID 				NUMBER(10),
LANGUAGE_ID 			NUMBER(10)
); 

CREATE TABLE REL_USER_SPORTS (
USER_ID 				NUMBER(10),
SPORTS_ID				NUMBER(10)
); 	

CREATE TABLE REL_USER_ACTIVITY (
USER_ID 				NUMBER(10),
ACTIVITY_ID				NUMBER(10)
); 

CREATE TABLE REL_USER_INTEREST (
USER_ID 				NUMBER(10),
INTEREST_ID				NUMBER(10)
); 

-- Stats
-----------------------------------------------------------------------

CREATE TABLE PRODUCT_CLUSTER_STAT (
PRODUCT_CLUSTER_ID 		NUMBER(10)		PRIMARY KEY,
TOTAL_PROD_IN_PC			NUMBER(10),						-- MSW 100300, ni: sum of movies in PC
TOTAL_NEW_PROD_IN_PC		NUMBER(10),						-- MSW 100500, sum of NEW products in PC
TOTAL_OLD_PROD_IN_PC		NUMBER(10),						-- MSW 100500, sum of OLD products in PC
W_TOTAL_PROD_IN_PC		NUMBER(14,4),					-- MSW 100500, Weight sum of products in PC
W_TOTAL_NEW_PROD_IN_PC		NUMBER(14,4),					-- MSW 100500, Weight sum of NEW products in PC
W_TOTAL_OLD_PROD_IN_PC		NUMBER(14,4)					-- MSW 100500, Weight sum of OLD products in PC
);

CREATE TABLE USER_CLUSTER_STAT (
USER_CLUSTER_ID 			NUMBER(10)		PRIMARY KEY,
TOTAL_USER_IN_UC			NUMBER(10)						-- MSW 100300
);

CREATE TABLE PRODUCT_STAT (
PRODUCT_ID 				NUMBER(10)		PRIMARY KEY,
PRODUCT_WEIGHT			NUMBER(5,4),					-- MSW 100500, 1/# of Product Clusters this product belongs to
TOTAL_USER_EVAL			NUMBER(10),						-- MSW 100300, # of times rated
AVG_USER_EVAL			NUMBER(7,6),					-- MSW 100300, Average Evaluation when seen
TOTAL_USER_SEEN			NUMBER(10),						-- MSW 100300, # of times seen
FRACTION_USER_SEEN		NUMBER(7,6),					-- MSW 100300, percentage seen
NEW_ADDITION_IND			NUMBER(1)						-- MSW 100400, Indicator whether a product is old (0) or new (1)				
);

CREATE TABLE USER_STAT (
USER_ID 				NUMBER(10)		PRIMARY KEY,
TOTAL_PROD_EVAL			NUMBER(10),						-- MSW 100300, # of Products Evaluated
AVG_PROD_EVAL			NUMBER(7,6),					-- MSW 100300, Rave (user's average rating in overall space)
TOTAL_PROD_SEEN			NUMBER(10),						-- MSW 100300, # of Products seen that were evaluated
FRACTION_PROD_SEEN		NUMBER(7,6)						-- MSW 100300, Eave (overall fraction of movies the user has seen out of those the user has been asked)
);

CREATE TABLE USER_PRODUCT_CLUSTER_STAT (
USER_ID 				NUMBER(10),
PRODUCT_CLUSTER_ID		NUMBER(10),
TOTAL_PROD_EVAL			NUMBER(10),						-- MSW 100300,
AVG_PROD_EVAL			NUMBER(7,6),					-- MSW 100300, Ri (user 's average rating in the i-th cluster)
TOTAL_PROD_SEEN			NUMBER(10),						-- MSW 100300,
FRACTION_OF_EVAL_SEEN		NUMBER(7,6),					-- MSW 100300, Ei (fraction of movie in the i-th movie cluster that the user has seen out of those the user has been asked)
FRACTION_OF_PC_EVAL		NUMBER(7,6),					-- MSW 100500, Fraction of PC Evaluated
TOTAL_NEW_PROD_EVAL		NUMBER(10),						-- MSW 100500
AVG_NEW_PROD_EVAL			NUMBER(7,6),					-- MSW 100500
TOTAL_NEW_PROD_SEEN		NUMBER(10),						-- MSW 100500
FRACTION_OF_NEW_EVAL_SEEN	NUMBER(7,6)						-- MSW 100500
);

CREATE TABLE PRODUCT_USER_CLUSTER_STAT (
USER_CLUSTER_ID		 	NUMBER(10),
PRODUCT_ID				NUMBER(10),
PROD_EVAL_MEAN_BY_UC		NUMBER(8,6),
PROD_EVAL_VARIANCE_BY_UC	NUMBER(8,6),
TOTAL_USER_SEEN			NUMBER(10),						-- MSW 092500 for Recommendation
TOTAL_USER_EVAL			NUMBER(10),						-- MSW 092500 for Recommendation
FRACTION_OF_UC_SEEN		NUMBER(7,6),
FRACTION_OF_UC_EVAL		NUMBER(7,6),
SCORE					NUMBER(10)						-- BK092400
);

-- Not sure if we store (Om 9/22/00)
CREATE TABLE INTERCLUSTER_DISTANCE (
USER_CLUSTER_ID1		 	NUMBER(10),
USER_CLUSTER_ID2		 	NUMBER(10),
INTERCLUSTER_DISTANCE		NUMBER(8,6)
);

-- Not sure if we store (Om 9/22/00)
CREATE TABLE USER_CLUSTER_DISTANCE (
USER_CLUSTER_ID		 	NUMBER(10),
USER_ID				NUMBER(10),
PRODUCT_ID				NUMBER(10),
USER_CLUSTER_VMEAN_DISTANCE	NUMBER(8,6)
);

-- Not sure if we store (Om 9/22/00)
CREATE TABLE USER_CLUSTER_MEAN_DISTANCE (
USER_CLUSTER_ID		 	NUMBER(10),
USER_ID				NUMBER(10),
MEAN_DISTANCE			NUMBER(8,6),
CALC_M1				NUMBER(6,3),					-- BK 092400 Added, MSW	Changed precision from 3,2 to 6,3
CALC_M2				NUMBER(6,3),					-- BK 092400 Added, MSW	Changed precision from 3,2 to 6,3
CALC_M3				NUMBER(6,3),					-- BK 092400 Added, MSW	Changed precision from 3,2 to 6,3
CALC_M4				NUMBER(6,3),					-- BK 092400 Added, MSW	Changed precision from 3,2 to 6,3
CALC_M11				NUMBER(6,3)						-- MSW 100200 Added for BWL
);

CREATE OR REPLACE VIEW all_user_prod_comb AS SELECT DISTINCT USER_ID.USER_ID, REL_PRODUCT_CLUSTER.PRODUCT_ID FROM USER_ID, REL_PRODUCT_CLUSTER;

---------------------------------------------------------------------------------------------------------
-- END SCHEMA CREATION
---------------------------------------------------------------------------------------------------------

-- DELETED MSW 100300
-- Redundant because of PRODUCT_USER_CLUSTER_STAT table
-- CREATE TABLE REL_PRODUCT_CLUSTER_USER (						-- BK092400 - Created for RecommendationManager
-- PRODUCT_CLUSTER_ID 		NUMBER(10),
-- USER_ID				NUMBER(10),
-- NUM_MOVIES_SEEN		NUMBER(10),
-- CALC_E				NUMBER(2,1),					-- BK092400 (Fraction of Movies User has seen in cluster)
-- CALC_R				NUMBER(2,1)						-- BK092400 (Average Rating for the User in Cluster)
-- );
